package servercore.http;

import servercore.statics.StaticValues;
import servercore.statics.StaticsMeothds;
import servercore.tcp.TcpServer;
import extension.file.EasyIni;
import extension.file.LogWriter;

public class HttpServer extends Thread implements StaticValues{

	/** HTTP 接続ポート番号 */
	private static int recvPort = 80;
	/** ルートディレクトリパス */
	private static String rootDirPath = "./";

	private static boolean isRunning = false;

	private static boolean useSecurity = false;

	private static String useCompress = null;

	private static EasyIni loadedIni = null;

	/**
	 * 接続ポート番号を設定
	 * @param portNum
	 */
	public static void setRecvPort(int portNum) {
		if(isRunning) {
			System.err.println("Server is running");
			return;
		}
		if(portNum > 0) {
			recvPort = portNum;
		}
	}

	/**
	 * 接続ポート番号を設定
	 * @param portNumStr
	 */
	public static void setRecvPort(String portNumStr) {
		if(isRunning) {
			System.err.println("Server is running");
			return;
		}
		int num = Integer.parseInt(portNumStr);
		setRecvPort(num);
	}

	/**
	 * ルートパスを設定
	 * @param rootPath
	 */
	public static void setRootDirPath(String rootPath) {
		rootDirPath = rootPath;
	}
	public static String getRootDirPath() {
		return rootDirPath;
	}

	public static void setUseSecurity(boolean flg) {
		useSecurity = flg;
	}
	public static void setUseSecurity(String  flg) {
		if(flg == null) {
			return;
		}
		flg = flg.toLowerCase();
		if("true".equals(flg)) {
			useSecurity = true;
		} else if("false".equals(flg)) {
			useSecurity = false;
		}
	}
	public static boolean useSecurity() {
		return useSecurity;
	}

	public static void setUseCompress(String alg) {
		useCompress = alg;
	}
	public static String getUseCompress() {
		return useCompress;
	}

	public static void setLoadIni(EasyIni ini) {
		if(isRunning) {
			System.err.println("Server is running");
			return;
		}
		if(ini != null) {
			loadedIni = ini;
		}
	}
	public static String getLoadedIniValue(String key) {
		return loadedIni.getPro(key);
	}
	public void run() {
		LogWriter log = new LogWriter(httpServerLogPath);
		TcpServer server = new TcpServer();
		try {
			TcpServer.setPortNum(recvPort);
			server.start();
			System.out.println("server started");
			isRunning = true;
			while(server.isAlive()) {
				try {
					Thread.sleep(10);
				} catch (InterruptedException e) {}
			}
			log.close();
			isRunning = false;
		} catch (Exception e1) {
			e1.printStackTrace();
		}
	}
}
